/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonObject;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsJsonParser;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;

class EventSelectorAcoustics
implements Acoustic {
    private final Map<State, Acoustic> pairs = new HashMap<State, Acoustic>();

    public EventSelectorAcoustics(JsonObject json, AcousticsJsonParser context) {
        for (State i : State.values()) {
            String eventName = i.getName();
            if (!json.has(eventName)) continue;
            this.pairs.put(i, context.solveAcoustic(json.get(eventName)));
        }
    }

    @Override
    public void playSound(SoundPlayer player, LivingEntity location, State event, Options inputOptions) {
        if (this.pairs.containsKey((Object)event)) {
            this.pairs.get((Object)event).playSound(player, location, event, inputOptions);
        } else if (event.canTransition()) {
            this.playSound(player, location, event.getTransitionDestination(), inputOptions);
        }
    }
}

